### Name: kernelize
### Title: Smooth expression values or scores
### Aliases: kernelmatrix getsteps kernelize
### Keywords: manip

### ** Examples

  data(stjd)
  genes = seq(100)
  geneLocations = abs(stjd$geneLocation[genes])
  geneExpression = stjd$expr[genes,]
  step.width = 100000
  steps = getsteps(geneLocations, step.width)
  weights = kernelmatrix(steps, geneLocations, rbf, list(gamma=1/10^13))
  kernelized = kernelize(geneExpression, weights)
  plot(steps, kernelized[1,])



