### Name: lapmix.Fit
### Title: Empirical Bayes Statistics for Differential Expression under
###   Laplace Model
### Aliases: lapmix.Fit
### Keywords: htest

### ** Examples


#  Simulate gene expression data under Laplace mixture model: 3000 genes with
#  4 duplicates each; one gene in ten is differentially expressed.

G <- 3000
Y <- NULL
sigma_sq <- 1/rgamma(G, shape=2.8, scale=0.04)
mu <- rexp(G, rate=1/(sigma_sq*1.2))-rexp(G, rate=1/(sigma_sq*1.2))
is.diff <- sample(c(0,1), replace=TRUE, prob=c(0.9,0.1), size=G)
mu <- mu*is.diff
for(g in 1:G)
        Y <- rbind(Y, rnorm(4,mu[g], sd=sqrt(sigma_sq[g])))

# with symmetric model
res <- lapmix.Fit(Y)
res$estimates
laptopTable(res, 20)
lap.volcanoplot(res, highlight=res$med.number)

# with asymmetric model
res2 <- lapmix.Fit(Y, asym=TRUE)
res2$estimates
laptopTable(res2, 20)
lap.volcanoplot(res2, highlight=res2$med.number)



