### Name: parallel.coordinates
### Title: Parallel coordinates: Plotting each observation across all
###   variables
### Aliases: parallel.coordinates
### Keywords: hplot

### ** Examples

if (require(rfcdmin)){
  data.there<-is.element("MC.053",objects())
    if ((sum(data.there) != length(data.there))) {
      ## obtaining the FCS objects from FHCRC data
      data(MC.053min)
    }
 
  dataMC<-MC.053@data

 
  if (interactive()) {
   par(mfrow=c(2,2))

    ### subset the data to the first 5 observations because it is too huge
    parallel.coordinates(dataMC[c(1:5),-6])
    ### the first 2 rows are a group and the last 3 rows are a different group
    parallel.coordinates(dataMC[c(1:5),-6], group=c(1,1,2,2,2))
    
    ### the same plot is scaled to 0,1 range
    parallel.coordinates(dataMC[c(1:5),-6], scaled=TRUE)
    parallel.coordinates(dataMC[c(1:5),-6], scaled=TRUE, group=c(1,1,2,2,2))
    
    parallel.coordinates(dataMC[c(1:5),1:4])
    ## changing the positions of the variables to the 1st, 5th, 8th, 16th
    ## positions on the horizontal x-axis
    parallel.coordinates(dataMC[c(1:5),1:4], varlabpos=c(1, 5, 8, 16))
    
    parallel.coordinates(dataMC[c(1:5),1:3])
    ## having the variable positions out of order of how they are plotted
    parallel.coordinates(dataMC[c(1:5),1:3], varlabpos=c(1, 15, 8))
    
    ## changing the labels of the vertical y-axis
    parallel.coordinates(dataMC[c(1:5),1:3], at.y=c(0, 500,
    1000),my.ylim=c(0, 1000),
    each.ylab=c("zero", "five hundred", "one thou"))
  }
}



