### Name: detectReplicas
### Title: detectReplicas
### Aliases: detectReplicas
### Keywords: utilities

### ** Examples


aD <- data.frame(ID=c("z", "x", "x", "x", "y", "z", "z", "y", "y"))
re <- detectReplicas(aD, identifiersToBeSkipped = c("Blank", "Control1", "Control2"))
stopifnot(re[["nrOfReplicas"]] == 3 )
stopifnot( re$spotReplicas[["z"]] == c(1,6,7) )
stopifnot( re$spotReplicas[["x"]] == c(2,3,4) )
stopifnot( re$spotReplicas[["y"]] == c(5,8,9) )

aD <- data.frame(ID=c("Blank", "Control1", "Blank", "Control2"))
re <- detectReplicas(aD, identifiersToBeSkipped = c("Blank", "Control1", "Control2"))
stopifnot(is.na(re[["nrOfReplicas"]]))

 ## Don't show: 
 aD <- data.frame(ID=c("Blank", "Blank", "x", "x", "Control1", "y", "x", "z", "y", "Control2"))
 re <- detectReplicas(aD, identifiersToBeSkipped = c("Blank", "Control1", "Control2"))
 stopifnot(is.na(re[["nrOfReplicas"]]))
 stopifnot( re$spotReplicas[["y"]] == c(6,9) )
 stopifnot( re$spotReplicas[["x"]] == c(3,4,7) )
 stopifnot( re$spotReplicas[["z"]] == c(8) )

 aD <- data.frame(ID=c("z", "x", "Control1", "y"))
 re <- detectReplicas(aD, identifiersToBeSkipped = c("Control1"))
 stopifnot(re[["nrOfReplicas"]] == 1 )
 stopifnot( re$spotReplicas[["x"]] == c(2) )
 stopifnot( re$spotReplicas[["y"]] == c(4) )
 stopifnot( re$spotReplicas[["z"]] == c(1) )

 aD <- data.frame(ID=c("Blank", "x", "x", "Control1", "y", "z", "z", "y", "Control2"))
 re <- detectReplicas(aD, identifiersToBeSkipped = c("Blank", "Control1", "Control2"))
 stopifnot(re$nrOfReplicas == 2 )
 stopifnot( re$spotReplicas[["x"]] == c(2,3) )
 stopifnot( re$spotReplicas[["y"]] == c(5,8) )
 stopifnot( re$spotReplicas[["z"]] == c(6,7) )
 ## End Don't show
  


