### Name: rmObjects
### Title: Delete objects
### Aliases: rmObjects
### Keywords: file

### ** Examples

  if ( interactive() ) {
    ddir <- paste( system.file(package="EBImage"), "images", sep="/" )
    a <- read.image( paste(ddir, "A04w1.jpg", sep="/") )
    w <- watershed( distmap( thresh(a, 10, 10) ) )
    display( normalize(w) )

    ## Not run: Often one need to delete small objects, here is the
    ## Not run: straightfoward way to construct an index
    index <- lapply( getObjects(w), function(x) which( x[, "size"] < 30) )

    ## Not run: now we delete these small objects
    w <- rmObjects( w, index )
    display( normalize(w) )

  }



