### Name: stam.net
### Title: Generate a Classifier Graph for StAM
### Aliases: stam.net
### Keywords: utilities

### ** Examples

# load some data
library(golubEsets)
data(Golub_Merge)
emat <- exprs(Golub_Merge)

# determine classifier graph for chip "hu6800" on
# biological processes, taking the positions of 
# probesets in Golub's expression matrix into account
net <- stam.net(chip="hu6800", root="GO:0003674", probes=rownames(emat))

# have a look
print(net)
print(net@nodes[[16]])
print(net@nodes$"GO:0007638")



