#!/usr/bin/perl

use strict;
use CGI;
use Symbol;

my $q = CGI::new();

my $problems = '';
		      
# collect data needed
my $datapath   = $q->param('datapath');

# verify consitency
my $filename = "$datapath"."busy.html";
if ($datapath eq "")             {$problems.=$q->li("No datapath defined");}
if (!(-e $filename)) {$problems.=$q->li("$filename not found");}

# report problem if any
if ($problems ne "") {
    print $q->header("text/html");
    print $q->start_html({-title=>"Show busy.html",
			  -style=>{'src'=>'/includes/style.css'}});
    print $q->h1("Show busy.html");
    print($q->p("The following problem(s) have been encountered:"),
	  $q->ul($problems));

    print($q->p("The following parameters have been received:"));
    my @parameters = $q->param();
    print "<UL>";
    foreach (@parameters) {
	print $q->li($_, " : ", $q->param($_));
    }
    print "</UL>";
    print $q->end_html();
    exit(0);
}

# read the busy.html file
my @lines;
my $buffer = "";
my $handle = gensym();
while ($buffer !~ m/\<\/HTML\>\s*/) {
    if (-e $filename) {
	open($handle, $filename);
	@lines = <$handle>;
	close($handle);
        $buffer = join("", @lines);
    }
}

# if ok 
print($q->header("text/html"),$buffer);
exit(0);

#
#   end of file
#
