### Name: summary.ProbBin.FCS
### Title: Chi-Squared/Standard Normal Approximation Summary Statistics for
###   a ProbBin.FCS object
### Aliases: summary.ProbBin.FCS
### Keywords: univar dplot

### ** Examples


if (require(rfcdmin)){
  ## obtaining the FCS objects from VRC data
if ( !(is.element("unst.1829", objects()) & is.element("st.1829", objects())) ){
data(VRCmin)
}
IFN.gamma.1<-unst.1829@data[1:2000,4]
IFN.gamma.2<-st.1829@data[1:2000,4]

#Probability binning using the control dataset to determine the breaks
PB1<-ProbBin.FCS(IFN.gamma.1, IFN.gamma.2, 200,
varname=colnames(unst.1829@data)[4], PBspec="by.control",MY.DEBUG=FALSE)

sum.PB1.1<-summary(PB1)
sum.PB1.2<-summary.ProbBin.FCS(PB1)

}



