### Name: extractGateHistory
### Title: Extracting the gating information from the history
### Aliases: extractGateHistory
### Keywords: data manip

### ** Examples

 if (require(rfcdmin)) {
      data.there<-is.element("MC.053",objects())
      if ((sum(data.there) != length(data.there))) {
        ## obtaining the FCS objects from VRC data
        data(MC.053min)
      }
  
####  foo1 : Gating type: uniscut, univariate single cut
foo1 <- createGate(MC.053, varpos=4, gatingrange=256,
                    type="uniscut", MY.DEBUG=TRUE)

#### foo2.3 : Gating type : biscut -/-
foo2.3 <- createGate(foo1, varpos=c(1,2),
                      gatingrange=c(256, 300),
                      type="biscut",
                      biscut.quadrant="-/-",
                      prev.gateNum=NULL,
                      MY.DEBUG=TRUE)

## obtain gate information for first uniscut gate
gate.info1<-extractGateHistory(foo1, gateNum=1)

## obtain gate information for the second biscut gate
gate.info2<-extractGateHistory(foo2.3, gateNum=2)

### foo2.3.1 : extraction
foo2.3.1 <- extractGatedData(foo2.3, gateNum=2,
                              IndexValue.In=1,
                              MY.DEBUG=TRUE)
## obtain the second biscut gate information after
## subset/extraction of row observations
gate.info2.1<-extractGateHistory(foo2.3.1, gateNum=2)
}



