get.h                package:rflowcyt                R Documentation

_E_s_t_i_m_a_t_e _t_h_e _c_r_i_t_i_c_a_l _b_a_n_d_w_i_d_t_h _f_o_r _s_p_e_c_i_f_i_c _n_u_m_b_e_r _o_f _m_o_d_e_s

_D_e_s_c_r_i_p_t_i_o_n:

     get.h finds the critical bandwidth for specific number of modes. 
     That is, it finds the smallest bandwidth for which "m" modes are
     present for a kernel density estimator.

_U_s_a_g_e:

     get.h(x, m = 1, prec = 0.001, hmin = 0, hmax = 1)

_A_r_g_u_m_e_n_t_s:

       x: the data vector in which to find the critical bandwidth 

       m: the number of modes for the critical bandwidth 

    prec: the precision for the resulting bandwidth 

    hmin: the minimum value to start searching for the critical
          bandwidth, h 

    hmax: the maximum value to start searching for the critical
          bandwidth, h 

_D_e_t_a_i_l_s:

     get.h uses the Gaussian kernel to estimate the density of a data
     vector given by x.  The bandwidth determines the spread of each
     data point.  Thus a larger bandwidth leads to a smoother density
     estaimate.  get.h finds the smallest bandwidth in which "m" modes
     are still present.

_V_a_l_u_e:

       h: the critical bandwidth, rescaled for the standardized
          x-values for direct comparison 

_A_u_t_h_o_r(_s):

     Kevin Rader

_R_e_f_e_r_e_n_c_e_s:

     B.W. Silverman (1981),Using Kernel Density Estimates to
     Investigate Multimodatlity. J.R. Statist. Soc. B,43,1,97-99.

_S_e_e _A_l_s_o:

     'get.p', 'emp.f', 'get.num.modes'

_E_x_a_m_p_l_e_s:

      set.seed(12345)
      x <- c(rnorm(20,0),rnorm(20,3))
      get.h(x)

