### Encoding: latin1

### Name: KEstimate
### Title: Estimate best number of Components for missing value estimation
### Aliases: kEstimate
### Keywords: multivariate

### ** Examples

## Load a sample metabolite dataset (metaboliteData)
data(metaboliteData)

# Now remove 10% of the data
rows <- nrow(metaboliteData)
cols <- ncol(metaboliteData)
cond<-matrix(runif(rows * cols),rows,cols) < 0.1
metaboliteData[cond] <- NA

# Do cross validation with ppca for component 1:3
nrmsep <- kEstimate(metaboliteData, method = "ppca", maxPcs = 3, nruncv=1)

# Plot the result
barplot(drop(nrmsep$nrmsep), xlab = "Components",ylab = "NRMSEP (1 iterations)")

# The best k value is:
print(nrmsep$mink)



