### Encoding: latin1

### Name: bpca
### Title: Bayesian PCA Missing Value Estimator
### Aliases: bpca
### Keywords: multivariate

### ** Examples

## Load a sample metabolite dataset (metaboliteData)
data(metaboliteData)

# Now remove 10% of the data
rows <- nrow(metaboliteData)
cols <- ncol(metaboliteData)
cond<-matrix(runif(rows * cols),rows,cols) < 0.1
metaboliteData[cond] <- NA

## Perform Bayesian PCA with 3 components
result <- pca(metaboliteData, method="bpca", nPcs=2, center=FALSE)

## Get the estimated principal axes (loadings)
loadings <- result@loadings

## Get the estimated scores
scores <- result@scores

## Get the estimated complete observations
cObs <- result@completeObs

## Now plot the scores
plotPcs(result, scoresLoadings=c(TRUE,FALSE))



