### Name: boot.resample
### Title: Non-parametric bootstrap resampling function in package
###   `multtest'
### Aliases: boot.resample
### Keywords: manip internal

### ** Examples


#data example: ALL data set
set.seed(99)
data<-matrix(rnorm(90),nr=9)

#closure
ttest<-meanX(psi0=0,na.rm=TRUE,standardize=TRUE,alternative="two.sided",robust=FALSE)

#test statistics
obs<-get.Tn(X=data,stat.closure=ttest,W=NULL)

#bootstrap null distribution (B=100 for speed)
nulldistn<-boot.resample(X=data,W=NULL,stat.closure=ttest,B=100,theta0=0,tau0=1,alternative="two.sided")

#unadjusted p-values
rawp<-apply((obs[1,]/obs[2,])<=nulldistn,1,mean)
sum(rawp<=0.01)




