### Name: getHomolog
### Title: Get homologs
### Aliases: getHomolog
### Keywords: methods

### ** Examples

if(interactive()){
from.mart <- useMart("ensembl","hsapiens_gene_ensembl")
to.mart <- useMart("ensembl","mmusculus_gene_ensembl")

#HUGO to Entrez Gene

homolog = getHomolog(id = 1:20, from.mart = from.mart, to.mart = to.mart, from.type = 'entrezgene', to.type = 'refseq')
show(homolog)

#ensembl to ensembl

homolog = getHomolog( id = "ENSG00000072778", from.mart = from.mart, from.type = "ensembl", to.type="ensembl",to.mart=to.mart)
show(homolog)

#Affy to Affy

homolog = getHomolog( id = "1939_at", to.array = "affy_mouse430_2", from.array = "affy_hg_u95av2", from.mart = from.mart, to.mart=to.mart )
show(homolog)

#Ensembl to Affy

homolog = getHomolog( id = "ENSG00000072778", to.array = "affy_mouse430_2", from.type = "ensembl", from.mart = from.mart, to.mart = to.mart )
show(homolog)

}



