### Name: MLIclust
### Title: An interface to various unsupervised machine learning methods
###   for ExpressionSets
### Aliases: hclustB agnesB dianaB pamB bclustB trainInds silhouetteB
###   claraB distMat fannyB isoMDSB cmeansB cshellB kmeansB
###   agnesB,ExpressionSet,numeric-method
###   bclustB,ExpressionSet,numeric-method
###   claraB,ExpressionSet,numeric-method
###   cmeansB,ExpressionSet,numeric-method
###   hclustB,ExpressionSet,numeric,missing-method
###   hclustB,ExpressionSet,numeric,ANY-method
###   hclustB,ExpressionSet,missing,numeric-method
###   cshellB,ExpressionSet,numeric-method
###   dianaB,ExpressionSet,numeric-method
###   fannyB,ExpressionSet,numeric-method
###   kmeansB,ExpressionSet,numeric-method
###   pamB,ExpressionSet,numeric-method
### Keywords: classif

### ** Examples

##get these from the source files
library(golubEsets)
data(Golub_Merge)
smallG <- Golub_Merge[1:60,]
set.seed(1234) # needed for nnet initialization
kmeansB( smallG, k=4 )
agnesB( smallG, k=5, height=0, FALSE )
dianaB( smallG, k=5, height=0, FALSE )
pamB( smallG, k=5, height=0, FALSE )
bclustB( smallG, k=5, height=0 )
cmeansB( smallG, k=5, height=0 )
cshellB( smallG, k=5, height=0 , iter.max=1)
#lcaB( BsmG, k=3 )
hclustB( smallG, k=4 )
hclustB( smallG, height=40000 )



