### Name: readSeq
### Title: Sequence extraction from a bank
### Aliases: readSeq readFasta readGbk readEmbl strReadFasta strReadGbk
###   strReadEmbl
### Keywords: utilities

### ** Examples

## Get a sequence from Ncbi
seqNcbi("BY608190",file="BY608190.gbk",type="G")

## Read Gbk file to buffer 0
readGbk("BY608190.gbk")

## Or to a character string
strReadGbk("BY608190.gbk")

## Write to Fasta file
writeFasta(file='toto.fa')

## Make an index to this file
indexFasta('toto.fa')
readFasta (file="toto.fa",seqno=0,from=1,to=159)

## Show seqence on buffer 0
getSeq()

## Make a Fake file
writeEmblLine(file='toto.embl',code='AC',header='tmp',append=FALSE)
writeEmblSeq(file='toto.embl')

## Make index on file toto.embl
indexEmbl('toto.embl')

## Read Embl file to buffer 0
readEmbl('toto.embl')

## Or read "directly"
strReadEmbl('toto.embl')




