### Name: randomSeq
### Title: Create random sequence
### Aliases: randomSeq shuffleSeq
### Keywords: utilities

### ** Examples

## Set seed of your choice (not requiered)
set.seed(3)

####  ----  RANDOMSEQ  ----
## Create a sequence of size 30, GC rich
randomSeq(prob = c(0.20, 0.30, 0.20, 0.30), letters = c("T", "C","A", "G"), n = 30)
## [1] "CTGGAACCGAGGGGTTCATCCCCCCAGTGA"

## use with bi-nucleotides
randomSeq(prob=rep(0.0625,16),letters = c("TT","TC","TA","TG","CT","CC","CA","CG","AT","AC","AA","AG","GT","GC","GA","GG"),n=10)
## [1] "CGCATGATCCCAGGCTAACT"

####  ----  SHUFFLESEQ  ----
## Create a sequence with 7 T, 3 C and A, and 4 G.
shuffleSeq(count=c(7,3,3,4,0),letters=c("T","C","A","G","N"))
## [1] "TATCTTTTGTCGGACGA"

## Same with bi-nucleotides
shuffleSeq(count=c(rep(4,4),rep(2,4),rep(1,4),rep(0,4)),letters = c("TT","TC","TA","TG","CT","CC","CA","CG","AT","AC","AA","AG","GT","GC","GA","GG"))
## [1] "TCTTTCCATTCCTTCTAGTGTACCCGTATACGTGTCTGTGTACTTCAACAACTTAT"

## From a real sequence:
seqNcbi("BY608190",file="BY608190.fa")
readFasta("BY608190.fa")

## create a random sequence from a real tri-nucleotides distribution
## Size of sequence will be 10*3.
randomSeq(compoSeq(wsize=3,p=TRUE),n=10)

## re assemble real tri-nucleotides of a real sequence
shuffleSeq(compoSeq(wsize=3,from=1,to=30,p=FALSE))




