gene.geneslist.sig        package:CoCiteStats        R Documentation

_C_o_m_p_u_t_e _3 _t_w_o-_w_a_y _t_a_b_l_e _s_t_a_t_i_s_t_i_c_s _a_n_d _p-_v_a_l_u_e_s, 
_w_i_t_h _4 _d_i_f_f_e_r_e_n_t _a_d_j_u_s_t_m_e_n_t_s, _f_o_r _P_u_b_M_e_d _c_o-_c_i_t_a_t_i_o_n

_D_e_s_c_r_i_p_t_i_o_n:

     This function calculates Concordance, Jaccard's index and Hubert's
     $Gamma$ with  no adjustment, adjusting for paper size (PS),
     adjusting for  gene size (GS) and both, to evaluate the
     significance of  co-citation of a gene of interest and a gene list

_U_s_a_g_e:

     gene.geneslist.sig(gene, geneslist, numPapers, PaperLen, n.resamp=100)

_A_r_g_u_m_e_n_t_s:

    gene: Gene of interest. 

geneslist: The gene list with which the co-citation of the gene of 
          interest is to be evaluated.

numPapers: Total number of PubMed papers for consideration.  Default is
          all PubMed papers in the 'humanLLMappings' package. 

PaperLen: The sizes of the PubMed papers for consideration.  Default is
          the paper size of all the PubMed papers in the 
          'humanLLMappings' package.

n.resamp: Number of resampling for generating empirical p-values.

_D_e_t_a_i_l_s:

_V_a_l_u_e:

     Statistics and resampling p-values for all 3 two-way tables along
     with the  4 adjustments for 'gene' and 'geneslist' based on 
     'n.resamp' resamplings.

_A_u_t_h_o_r(_s):

     Beiying Ding

_R_e_f_e_r_e_n_c_e_s:

     Testing Gene Associations Using Co-citation, by B. Ding and R.
     Gentleman. Bioconductor Technical Report, 2004

_S_e_e _A_l_s_o:

     'actorAdjTable','paperLen',  'twTStats', 'twowayTable'

_E_x_a_m_p_l_e_s:

      
     gene <- "705"
     geneslist <- "7216"
     numPapers <- length(unique(unlist(eapply(humanLLMappingsLL2PMID,
                                   function(x) x))))

     PaperLen <- paperLen(ls(humanLLMappingsLL2PMID))$Counts

     gene.geneslist.sig(gene, geneslist, numPapers, PaperLen, n.resamp=50)
       

