### Name: Standard labeling of edges with integers
### Title: Standard labeling of edges with integers
### Aliases: ftM2int int2ftM
### Keywords: graphs

### ** Examples

 nNodes <- 200
 nEdges <- choose(nNodes, 2)
 i <- 1:nEdges
 ft <- int2ftM(i)
 ft[1:6,]
 stopifnot(all(ft[,1]>ft[,2])) ## always from higher to lower
 stopifnot(!any(duplicated(paste(ft[,1], ft[,2]))))
 stopifnot(ft[nEdges, 1]==nNodes, ft[nEdges, 2]==nNodes-1) 

 j <- ftM2int(ft)
 stopifnot(all(i==j))



