### Name: setVirtualMethod
### Title: Set a virtual method for a given signature
### Aliases: setVirtualMethod
### Keywords: methods

### ** Examples

setClass("myMatrix")
setVirtualMethod("dim", "myMatrix")
setVirtualMethod("dimnames", "myMatrix")
setClass("myMatrix2", representation(val="numeric",
                                     d = "integer",
                                     dn = "list"),
         contains="myMatrix")
x <- new("myMatrix2", val=1:4, d = as.integer(c(2, 2)),
         dn = list(LETTERS[1:2], letters[1:2]))
## A call dim(x) or dimnames(x) would generate an error here
setMethod("dim", "myMatrix", function(x) x@d)
setMethod("dimnames", "myMatrix", function(x) x@dn)
dim(x)
dimnames(x)



