### Name: exprExternal-class
### Title: Class exprExternal, a subclass of exprSet, and methods for
###   manipulating objects of class exprExternal
### Aliases: exprExternal-class coerce,exprSet,exprExternal-method
###   exprs2excel,exprExternal-method exprs,exprExternal-method
###   exprs<-,exprExternal,ANY-method
###   exprs<-,exprExternal,indirectExternalMatrix-method
###   initialize,exprExternal-method
###   iter,exprExternal,missing,function-method
###   se.exprs,exprExternal-method
###   se.exprs<-,exprExternal,indirectExternalMatrix-method
###   write.exprs,exprExternal-method
### Keywords: classes methods

### ** Examples

  ## Run the examples from exprSet manual page
  library('externalVector')
  library('Biobase')
  data(geneData)
  data(geneCov)
  covdesc<- list("Covariate 1", "Covariate 2", "Covariate 3")
  names(covdesc) <- names(geneCov)
  pdata <- new("phenoData", pData=geneCov, varLabels=covdesc)
  pdata[1,]
  pdata[,2]

  eset <- as(new("exprSet", exprs=geneData, phenoData=pdata),
             "exprExternal")
  eset
  eset[,1:10]
  eset[,1]
  eset[1,]
  eset[1,1]
  eset[1:100,]
  eset[1:44,c(2,4,6)]
  Means <- iter(eset, f=mean)

  

  sp1 <- split(eset, c(1,2))
  sp2 <- split(eset, c(rep(1,6), rep(2,7)))



