### Name: smtools
### Title: Some Tools for Symmetric Matrices
### Aliases: sm2vec sm.indexes vec2sm
### Keywords: utilities

### ** Examples

# load corpcor library
library("corpcor")

# covariance matrix
m.cov <- rbind(
 c(3,1,1,0),
 c(1,3,0,1),
 c(1,0,2,0),
 c(0,1,0,2)
)
m.cov

# convert into vector (including diagonals
v <- sm2vec(m.cov, diag=TRUE)
v.idx <- sm.indexes(m.cov, diag=TRUE)
v
v.idx

# put back to symmetric matrix
vec2sm(v, diag=TRUE)

# vector not in the original order
sv <- sort(v)
sv
ov <- order(v)
ov
vec2sm(sv, diag=TRUE, order=ov)



