### Name: cor.fit.mixture
### Title: Fit Mixture Distribution to Estimated Correlation Coefficients
### Aliases: cor.fit.mixture
### Keywords: htest

### ** Examples

# load GeneTS library
library("GeneTS")

# simulate mixture distribution
r <- rcor0(700, kappa=10)
u1 <- runif(200, min=-1, max=0.5)
u2 <- runif(200, min=0.5, max=1)
rc <- c(r, u1, u2)

# estimate kappa and eta0 (=7/9)
c1 <- cor.fit.mixture(r)
c1$eta0
c1$kappa
c2 <- cor.fit.mixture(rc) 
c2$eta0
c2$kappa




