cat("\n------ First try to make an Embl file  -------\n")

cat("We will use this sequence \n")

s<-"gtcatgcatgctaggtgacagttaaaatgcgtctaggtgacagtctaacaa"
placeString(s)


cat("\n  Add an ID, an access number and date\n")

readline("Next")

writeEmblComment(file="toto.embl",code="ID",text="foo",append=FALSE)

writeEmblComment(file="toto.embl",code="AC",text="access_number",append=TRUE)

writeEmblComment (file="toto.embl",code="DT",text=date())


cat("\n Add a description description \n")

readline("Next")


writeEmblComment (file="toto.embl",code="DE",text="Similar to the magic protein")

cat("\n  Add lines with 'CC   bla bla bla' and a line 'XX'\n")
writeEmblComment(file="toto.embl",code="CC",text="This is a comment for \
this dummy sequence... I try to be long enough to show that this comment \
will be written on several lines",append=TRUE)


cat("\n\n Add feature; i.e. line like FT  CDS  bla bla bla \n")

readline("Next")

writeEmblLine(file="toto.embl",code="FT",header="CDS",text="1..12",
              nextfield = FALSE)
writeEmblLine(file="toto.embl",code="FT",header="",text="/codon_start=2",
              nextfield = FALSE)
writeEmblLine(file="toto.embl",code="FT",header="",text="/gene=\"toto\"",
              nextfield = FALSE)
writeEmblLine(file="toto.embl",code="FT",header="",text="/note=\"Here is \
what I think about this gene\"",nextfield = FALSE)

cat("\n Translation \n")
prot <- translate(seqno=0,from=getOrfs()[1,1],to=getOrfs()[1,2])
writeEmblLine (file="toto.embl",code='FT',header='',
text=paste('/translation="',prot ,'\"',sep=''),nextfield =TRUE)




cat("\n Add sequence \n")
readline("Next")

writeEmblSeq(file="toto.embl")


cat("\n Add another sequence description \n")
readline("Next")

writeEmblComment(file="toto.embl",code="ID",text="foo2",append=TRUE)
writeEmblComment(file="toto.embl",code="AC",text="access_number2",append=TRUE)
writeEmblComment (file="toto.embl",code="DT",text=date())
writeEmblLine(file="toto.embl",code="FT",header="CDS",text="1..12",
              nextfield = FALSE)
writeEmblLine(file="toto.embl",code="FT",header="",text="/codon_start=2",
              nextfield = FALSE)
writeEmblLine(file="toto.embl",code="FT",header="",text="/gene=\"toto\"",
              nextfield = FALSE)
prot <- translate(seqno=0,from=getOrfs()[1,1],to=getOrfs()[1,2])
writeEmblLine (file="toto.embl",code='FT',header='',
text=paste('/translation="',prot ,'\"',sep=''),nextfield =TRUE)
writeEmblSeq(file="toto.embl")

cat("\n Show file \n")
readline("Next")

cat(paste(readLines("toto.embl"),collapse='\n'))
