### Name: exprSet
### Title: Class for Microarray Data and Methods for Processing Them
### Aliases: class:exprSet exprSet exprSet-class abstract,exprSet-method
###   annotation<-,exprSet-method annotation,exprSet-method
###   as.data.frame.exprSet,exprSet-method assayData,exprSet-method
###   [,exprSet-method description<-,exprSet-method
###   description,exprSet-method exprs2excel,exprSet-method
###   exprs<-,exprSet-method exprs,exprSet-method
###   geneNames<-,exprSet-method geneNames,exprSet-method
###   iter,exprSet,missing,function-method iter,exprSet,missing,list-method
###   iter,exprSet,character,function-method notes<-,exprSet-method
###   notes,exprSet-method sampleNames<-,exprSet-method
###   sampleNames,exprSet-method se.exprs<-,exprSet-method
###   se.exprs,exprSet-method show,exprSet-method
###   split,exprSet,factor,missing-method
###   split,exprSet,vector,missing-method update2MIAME,exprSet-method
###   write.exprs,exprSet-method as.data.frame.exprSet split write.exprs
###   update2MIAME exprs2excel
### Keywords: methods classes

### ** Examples

  data(geneData)
  data(geneCov)
  covdesc<- list("Covariate 1", "Covariate 2", "Covariate 3")
  names(covdesc) <- names(geneCov)
  pdata <- new("phenoData", pData=geneCov, varLabels=covdesc)
  pdata[1,]
  pdata[,2]

  expr <- new("exprSet", exprs=geneData, phenoData=pdata)
  expr
  expr[,1:10]
  expr[,1]
  expr[1,]
  expr[1,1]
  expr[1:100,]
  expr[1:44,c(2,4,6)]
  Means <- iter(expr, f=mean)

  chkdich <- function(x) if(length(unique(x))!=2) stop("x not dichotomous")
  mytt <- function(x,y) {
     chkdich(x)
     d <- split(y,x)
     t.test(d[[1]],d[[2]])$p.val
  }

  Tpvals <- iter(expr, "cov1", mytt )

  sp1 <- split(expr, c(1,2))
  sp2 <- split(expr, c(rep(1,6), rep(2,7)))

  sampleNames(expr)
  sampleNames(expr) <- letters

  # as.data.frame.exprSet - example
  data(sample.exprSet)
  sd.genes <- esApply(sample.exprSet, 1, sd)
  dataf <- as.data.frame(sample.exprSet)
  dataf <- cbind(dataf, sd.genes=rep(unname(sd.genes), length=nrow(dataf)))
  coplot(sd.genes ~ exprs | sex+type, data=dataf)




