### Name: twilight.filtering
### Title: A function for permutation filtering
### Aliases: twilight.filtering
### Keywords: datagen

### ** Examples

### Leukemia data set of Golub et al. (1999).
library(golubEsets)
data(golubTrain)

### Variance-stabilizing normalization of Huber et al. (2002).
library(vsn)
golubNorm <- vsn(exprs(golubTrain))

### A binary vector of class labels.
id <- as.numeric(golubTrain$ALL.AML)

### Do an unpaired t-test.
### Let's have a quick example with 50 filtered permutations only.
### With num.take=10, we only need 5 iteration steps.
a <- twilight.filtering(golubNorm,id,method="t",num.perm=50,num.take=10)
dim(a$yperm)

### Let's see if the filtered permutations really produce uniform p-value distributions.
### The first row is the original labeling, so we try the second permutation.
a$yperm <- a$yperm[-1,]
b <- twilight.pval(golubNorm,a$yperm[1,],method="t",yperm=a$yperm)
hist(b$result$pvalue)



