### Name: costMatrix
### Title: Segmentation cost matrix
### Aliases: costMatrix
### Keywords: manip

### ** Examples

d = 4
x = apply(matrix(rnorm(200), ncol=d), 2, cumsum)
maxk = 30
 
G = costMatrix(x, maxk=maxk)
 
G.pedestrian = matrix(NA, nrow=nrow(G), ncol=ncol(G))
for(i in 1:(ncol(G)))
  for(k in 1:min(nrow(G), nrow(x)-i+1))
    G.pedestrian[k, i] = (k*d-1)/d*var(as.vector(x[i:(i+k-1), ]))
 
stopifnot(identical(is.na(G), is.na(G.pedestrian)))
stopifnot(max(abs(G-G.pedestrian), na.rm=TRUE) <= 1e-6)



