### Name: stepWithinNorm
### Title: Stepwise within-slide normalization function
### Aliases: stepWithinNorm
### Keywords: models

### ** Examples

# Examples use swirl dataset, for description type ? swirl
data(swirl)

# Apply stepwise normalization for the first slide
res.swirl1 <- stepWithinNorm(swirl[,1])

# normalized data
norm.swirl <- res.swirl1[[1]]

# stepwise procedure
step.swirl <- res.swirl1[[2]]

# using a stepwise procedure different than the default
# corrects intensity (A) and print-tip (PT), this can be
# carried out in two ways:
# 1)
steps <- list(
            wholeChipA = list(med = fitWithin(fun="medfit"),
                              rlm = fitWithin(fun="rlmfit"),
                              loess = fitWithin(fun="loessfit")),
            printTipA = list(med = fitWithin(z.fun="maPrintTip", fun="medfit"),
                             rlm = fitWithin(z.fun="maPrintTip", fun="rlmfit"),
                             loess = fitWithin(z.fun="maPrintTip",fun="loessfit")))
                             
#2)                          
steps <- makeStepList(PL=NULL, Spatial2D=NULL)
## Not run: 
##D res.swirl <- stepWithinNorm(swirl[,1], wf.loc=steps)
## End(Not run)

# using AIC criterion for the first slide
## Not run: 
##D res.swirl <- stepWithinNorm(swirl[,1], criterion="A")
## End(Not run)



