### Name: plotdensity.FCS
### Title: Create density plots one parameter of one (or more) FCS
###   object(s)
### Aliases: plotdensity.FCS densityplot.FCS
### Keywords: hplot

### ** Examples


 require(locfit)
 require(rfcdmin)

##Exemple I:
 data(flowcyt.fluors)

 ## Draw a  density plot for the Foward scatter parameter 
 mat <- matrix(c(1:2),1,2,byrow=TRUE)
 nf <- layout(mat,respect=TRUE)
 plotdensity.FCS(flowcyt.fluors[1:8],varpos=c(1),main="FSC density plot at time point 1",ylim=c(0,0.015),ylab="density of cells")
 legend(450,0.012,paste("stain",c(1:8),sep=""),col=c(1:8),pch=22)
 plotdensity.FCS(flowcyt.fluors[65:72],varpos=c(1),main="FSC density plot at time point 9",ylim=c(0,0.015),ylab="density of cells")
 legend(450,0.012,paste("stain",c(1:8),sep=""),col=c(1:8),pch=22)

 ##Example II
 if (require(rfcdmin)) {
  ##Obtain the location of the fcs files 
  pathFiles<-system.file("bccrc", package="rfcdmin")
  drugFiles<-dir(pathFiles)

  ## Read a serie of FCS files
  drugData<-read.series.FCS(drugFiles,path=pathFiles,MY.DEBUG=FALSE)

  }

 ## Extract fluorescent information from the serie of FCS files
 drug.fluors<-lapply(drugData,fluors)

 ##Draw a density plot for the Foward SCatter parameter for the
 ##differents aliquots (of the same cell line) tested with different
 ##compounds.
 plotdensity.FCS(drug.fluors,varpos=c(1),main="FSC for the aliquots treated with different compounds",ylim=c(0,0.005),ylab="Density of cells")



