### Name: boxplot.FCS
### Title: Create boxplots one parameter of one (or more) FCS object(s)
### Aliases: boxplot.FCS
### Keywords: aplot

### ** Examples

 ## Example I:
 require(rfcdmin)
 data(flowcyt.fluors)

 ## Draw a boxplot for the Foward SCatter parameter for the time points 1
 ## and 6 (in this experiment, each time point corresponds to a column of
 ## a 96 wells plates)
 mat <- matrix(c(1:2),1,2,byrow=TRUE)
 nf <- layout(mat,respect=TRUE)
 boxplot.FCS(flowcyt.fluors[1:8],varpos=c(1),col=c(1:8),main="FSC across stains time point 1",names=paste("stain",c(1:8),sep=""))
 boxplot.FCS(flowcyt.fluors[65:72],varpos=c(1),col=c(1:8),main="FSC across stains time point 9",names=paste("stain",c(1:8),sep=""))

 ##Example II:
 ## Read a serie of FCS files
 if (require(rfcdmin)) {

 ##obtaining the location of the fcs files in the data
  pathFiles<-system.file("bccrc", package="rfcdmin")
  drugFiles<-dir(pathFiles)

 ## reading in the FCS files
  drugData<-read.series.FCS(drugFiles,path=pathFiles,MY.DEBUG=FALSE)
  }

 ##Extract fluorescent information from the serie of FCS files
 drug.fluors<-lapply(drugData,fluors)

 ##Draw a boxplot for the Foward SCatter parameter
 ##for the differents aliquots (of the same cell line)
 ##tested with different compounds. 
 boxplot.FCS(drug.fluors,varpos=c(1),col=c(1:8),main="FSC of differents aliquots from the same cell line treated with different compounds.")

 


