### Name: cytoFrame-class
### Title: 'cytoFrame': a class for storing observed quantitative
###   properties from a population of cells, for example from a FACS run or
###   from automated microscopy
### Aliases: cytoFrame-class [,cytoFrame-method
###   description,cytoFrame-method description<-,cytoFrame,character-method
###   exprs,cytoFrame-method exprs<-,cytoFrame,matrix-method
###   colnames,cytoFrame-method colnames<-,cytoFrame-method
###   show,cytoFrame-method plot,cytoFrame,missing-method $.cytoFrame
### Keywords: classes

### ** Examples


intens <- matrix(runif(100), ncol=4)
colnames(intens) <- c("FL1-H", "FL2-H", "FL3-H", "FL4-H")

a <- new("cytoFrame",
          exprs=intens,
          description=c(name="example data", date=date()))

description(a)
dim(exprs(a))           

a[1:3, -4]

plot(a)




