### Name: prepareAxis
### Title: Reduces a tree of selected items to a vector of non-overelapping
###   regions with minimal p-value
### Aliases: prepareAxis
### Keywords: utilities

### ** Examples

namedv1 <- c(0.01,0.1)
names(namedv1) <- c("GeneA", "GeneB")
namedv2 <- c(0.01,0.01)
names(namedv2) <- c("GeneB", "GeneC")
namedv3 <- c(0.5,0.1)
names(namedv3) <- c("GeneD", "GeneE")

a1 <- list(annotationA = namedv1,
           annotationB = namedv2,
           annotationC = namedv3)
a2 <- list(annotationA = namedv2,
           annotationB = namedv3,
           annotationC = namedv1)
b <- list(list(a1,a2),list(a2,a1))

c <- minimizeSelection(b, 3)

clusters <- list(list(c(1,2),c(8,9)),list(c(20,21),c(20,21)))

prepareAxis(c, clusters, 3)



