### Name: WriteEmblSeq
### Title: Write to Embl file
### Aliases: writeEmblLine writeEmblComment writeEmblSeq
### Keywords: utilities

### ** Examples


s<-"gtcatgcatgctaggtgacagttaaaatgcgtctaggtgacagtctaacaa"
placeString(s)

# Add lines with "CC   bla bla bla" and a line "XX"
writeEmblComment(file="toto.embl",code="CC",text="This is a comment for \
this dummy sequence... I try to be long enough to show that this comment \
will be written on several lines",append=FALSE)

# Add a line with "FT  CDS  bla bla bla"
writeEmblLine(file="toto.embl",code="FT",header="CDS",text="<1..12",
              nextfield = FALSE)
# Add lines with "FT       bla bla bla"
writeEmblLine(file="toto.embl",code="FT",header="",text="/codon_start=2",
              nextfield = FALSE)
writeEmblLine(file="toto.embl",code="FT",header="",text="/gene=\"toto\"",
              nextfield = FALSE)
writeEmblLine(file="toto.embl",code="FT",header="",text="/note=\"Here is \
what I think about this gene\"",nextfield = TRUE)

# Add sequence
writeEmblSeq(file="toto.embl")



