## ----setup, echo=FALSE-----------------------------------------------------
knitr::opts_chunk$set(collapse=TRUE, comment = "#>")
suppressPackageStartupMessages(library(universalmotif))

## ----logo1,fig.cap="Sequence logo of a Position Probability Matrix",echo=FALSE,fig.small=TRUE----
motif <- create_motif(c("AAGAAT", "ATCATA", "AAGTAA", "AACAAA", "ATTAAA",
                        "AAGAAT"), type = "PPM", pseudocount = 0)
view_motifs(motif, use.type="PPM")

## ----logo2,fig.cap="Sequence logo of an Information Content Matrix",echo=FALSE,fig.small=TRUE----
motif <- create_motif(c("AAGAAT", "ATCATA", "AAGTAA", "AACAAA", "ATTAAA",
                        "AAGAAT"), type = "PPM", pseudocount = 0)
view_motifs(motif)

