## ----include=FALSE-------------------------------------------------------
library(knitr)
opts_chunk$set(
concordance=TRUE
)

## ----include=FALSE-------------------------------------------------------
library(knitr)
opts_chunk$set(
concordance=TRUE
)

## ----load.package, echo=FALSE, warning=FALSE, message=FALSE----
  options(width=60)
  library(synergyfinder)

## ----loading.data-----------------------------------------
data("mathews_screening_data")
head(mathews_screening_data)

## ---------------------------------------------------------
# Set the random number seed for generating noises.
set.seed(1)
dose.response.mat <- ReshapeData(mathews_screening_data,
                                 data.type = "viability",
                                 impute = TRUE,
                                 noise = TRUE,
                                 correction = "non")

## ---------------------------------------------------------
str(dose.response.mat)

## ----fig.show='hide'--------------------------------------
  PlotDoseResponse(dose.response.mat)

## ----fig.show='hide'--------------------------------------
  PlotDoseResponse(dose.response.mat, save.file = TRUE)

## ---------------------------------------------------------
  synergy.score <- CalculateSynergy(data = dose.response.mat,
                                    method = "ZIP")

## ---------------------------------------------------------
  str(synergy.score)

## ----fig.show='hide'--------------------------------------
  PlotSynergy(synergy.score, type = "all", save.file = TRUE)

