## ----setup, include=FALSE--------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----import_tree, message=FALSE--------------------------------------------
library(ape)

tree <- read.tree(system.file("extdata", "ZIKV.newick", package = "sitePath"))

## ----add_alignment, message=FALSE------------------------------------------
library(sitePath)

alignment_file <- system.file("extdata", "ZIKV.fasta", package = "sitePath")
tree <- addMSA(tree, alignment_file, "fasta")

## ----sneakPeek_plot--------------------------------------------------------
preassessment <- sneakPeek(tree)
plot(preassessment$similarity, preassessment$pathNum)

## ----get_sitePath----------------------------------------------------------
paths <- lineagePath(tree, 0.996)
paths

## ----plot_paths------------------------------------------------------------
plot(paths, no.margin = TRUE)

## ----find_fixations--------------------------------------------------------
fixations <- fixationSites(paths)
fixations

## ----get_tipNames----------------------------------------------------------
sp <- extractTips(fixations, 139)
sp

## ----plot_fixations--------------------------------------------------------
plotSingleSite(fixations, 139)

## ----plot_sites------------------------------------------------------------
plotSingleSite(paths, 139)
plotSingleSite(paths, 763)

## ----find_SNP--------------------------------------------------------------
snps <- SNPsites(tree)
plotSingleSite(paths, snps[4])
plotSingleSite(paths, snps[5])

## ----group_tips------------------------------------------------------------
grouping <- groupTips(tree)
grouping

## ----session_info----------------------------------------------------------
sessionInfo()

