/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.spectrum;

import com.compomics.util.enumeration.MolecularElement;
import com.compomics.util.general.IsotopicDistribution;
import com.compomics.util.general.IsotopicDistributionSpectrum;
import com.compomics.util.general.MassCalc;
import com.compomics.util.general.UnknownElementMassException;
import com.compomics.util.gui.spectrum.GraphicsPanel;
import com.compomics.util.interfaces.SpectrumFile;
import com.compomics.util.protein.AASequenceImpl;
import com.compomics.util.protein.MolecularFormula;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import org.apache.log4j.Logger;

public class IsotopicDistributionPanel
extends GraphicsPanel {
    Logger logger = Logger.getLogger(MolecularFormula.class);
    private Color aSpectrumPeakColor = Color.RED;
    private Color aSpectrumProfileModeLineColor = Color.PINK;
    private ArrayList<AASequenceImpl> peptideSequences = null;
    private ArrayList<Integer> peptideCharges = null;
    private HashMap<String, MolecularFormula> iElements;

    public IsotopicDistributionPanel(String peptideSequence, Integer peptideCharge, boolean profileMode, int labelDifference) throws IOException {
        this.currentGraphicsPanelType = profileMode ? GraphicsPanel.GraphicsPanelType.isotopicDistributionProfile : GraphicsPanel.GraphicsPanelType.isotopicDistributionCentroid;
        this.getElements();
        AASequenceImpl validatedPeptideSequence = this.validatePeptideSequence(peptideSequence);
        this.peptideSequences = new ArrayList();
        this.peptideSequences.add(validatedPeptideSequence);
        this.peptideCharges = new ArrayList();
        this.peptideCharges.add(peptideCharge);
        IsotopicDistributionSpectrum isotopicDistributionSpectrum = this.calculateIsotopicDistribution(validatedPeptideSequence, peptideCharge, labelDifference);
        this.dataSetCounter = 0;
        this.processIsotopicDistribution(isotopicDistributionSpectrum, this.aSpectrumPeakColor, this.aSpectrumProfileModeLineColor);
        this.iXAxisStartAtZero = false;
        this.rescaleWithLeftSidePadding();
        this.iCurrentDrawStyle = GraphicsPanel.DrawingStyle.LINES;
        this.setBorder(BorderFactory.createEtchedBorder(1));
        this.setBackground(Color.WHITE);
        this.iYAxisLabel = "Int (%)";
        this.iSpecPanelListeners = new ArrayList();
        this.addListeners();
    }

    private IsotopicDistributionSpectrum calculateIsotopicDistribution(AASequenceImpl validatedPeptideSequence, Integer peptideCharge, int labedDifference) {
        double mzValue = validatedPeptideSequence.getMz(peptideCharge);
        IsotopicDistribution lIso = validatedPeptideSequence.getIsotopicDistribution();
        if (labedDifference > 0) {
            lIso.setLabelDifference(labedDifference);
        }
        HashMap<Double, Double> lPeaks = new HashMap<Double, Double>();
        try {
            for (int i = 0; i < 15; ++i) {
                int j;
                int numberOfSidePeaks = 10;
                if (this.currentGraphicsPanelType.equals((Object)GraphicsPanel.GraphicsPanelType.isotopicDistributionProfile)) {
                    for (j = 0; j < numberOfSidePeaks; ++j) {
                        lPeaks.put(mzValue + (double)i * (new MassCalc().calculateMass("H") / (double)peptideCharge.intValue()) - 0.01 * (double)(numberOfSidePeaks - j), lIso.getPercMax()[i] * (double)j * 10.0);
                    }
                }
                lPeaks.put(mzValue + (double)i * (new MassCalc().calculateMass("H") / (double)peptideCharge.intValue()), lIso.getPercMax()[i] * 100.0);
                if (!this.currentGraphicsPanelType.equals((Object)GraphicsPanel.GraphicsPanelType.isotopicDistributionProfile)) continue;
                for (j = 1; j <= numberOfSidePeaks; ++j) {
                    lPeaks.put(mzValue + (double)i * (new MassCalc().calculateMass("H") / (double)peptideCharge.intValue()) + 0.01 * (double)j, lIso.getPercMax()[i] * (double)(100 - j * 10));
                }
            }
        }
        catch (UnknownElementMassException ume) {
            this.logger.error(ume.getMessage(), ume);
        }
        IsotopicDistributionSpectrum lSpecFile = new IsotopicDistributionSpectrum();
        lSpecFile.setCharge(peptideCharge);
        lSpecFile.setPrecursorMZ(mzValue);
        lSpecFile.setPeaks(lPeaks);
        return lSpecFile;
    }

    public void addAdditionalDataset(String peptideSequence, Integer peptideCharge, Color dataPointAndLineColor, Color areaUnderCurveColor, int labelDifference) throws IOException {
        AASequenceImpl validatedPeptideSequence = this.validatePeptideSequence(peptideSequence);
        this.peptideSequences.add(validatedPeptideSequence);
        this.peptideCharges.add(peptideCharge);
        IsotopicDistributionSpectrum isotopicDistributionSpectrum = this.calculateIsotopicDistribution(validatedPeptideSequence, peptideCharge, labelDifference);
        this.processIsotopicDistribution(isotopicDistributionSpectrum, dataPointAndLineColor, areaUnderCurveColor);
        this.rescaleWithLeftSidePadding();
        this.showFileName = false;
        this.showPrecursorDetails = false;
        this.showResolution = false;
    }

    private void rescaleWithLeftSidePadding() {
        double tempMinXValue = this.getMinXAxisValue();
        if ((tempMinXValue -= 1.0) < 0.0) {
            tempMinXValue = 0.0;
        }
        this.rescale(tempMinXValue, this.getMaxXAxisValue());
    }

    private AASequenceImpl validatePeptideSequence(String peptideSequence) throws IOException {
        String lSeq = peptideSequence;
        lSeq = lSeq.trim().toUpperCase();
        lSeq = lSeq.replace("\n", "");
        lSeq = lSeq.replace("\t", "");
        lSeq = lSeq.replace(" ", "");
        for (int i = 0; i < lSeq.length(); ++i) {
            String lLetter = String.valueOf(lSeq.charAt(i));
            if (this.isElement(lLetter)) continue;
            throw new IOException(lLetter + " at position " + (i + 1) + " is not a valid element!");
        }
        if (lSeq.length() == 0) {
            throw new IOException("Sequence cannot be of length zero!");
        }
        return new AASequenceImpl(lSeq);
    }

    private void getElements() {
        this.iElements = new HashMap();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("elements.txt")));
            String[] lHeaderElements = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                if (line.startsWith("Header")) {
                    String lTemp = line.substring(line.indexOf("=") + 1);
                    lHeaderElements = lTemp.split(",");
                    continue;
                }
                String lAa = line.substring(0, line.indexOf("="));
                String[] lContribution = line.substring(line.indexOf("=") + 1).split(",");
                MolecularFormula lAaFormula = new MolecularFormula();
                for (int i = 0; i < lHeaderElements.length; ++i) {
                    for (MolecularElement lMolecularElement : MolecularElement.values()) {
                        if (!lMolecularElement.toString().equalsIgnoreCase(lHeaderElements[i])) continue;
                        lAaFormula.addElement(lMolecularElement, Integer.valueOf(lContribution[i]));
                    }
                }
                this.iElements.put(lAa, lAaFormula);
            }
            br.close();
        }
        catch (Exception e) {
            this.logger.error(e);
        }
    }

    public boolean isElement(String lElement) {
        MolecularFormula lValue = this.iElements.get(lElement);
        return lValue != null;
    }

    private void processIsotopicDistribution(SpectrumFile aSpecFile, Color dataPointAndLineColor, Color areaUnderCurveColor) {
        if (this.dataSetCounter == 0) {
            this.iXAxisData = new ArrayList();
            this.iYAxisData = new ArrayList();
        }
        this.iDataPointAndLineColor.add(dataPointAndLineColor);
        this.iAreaUnderCurveColor.add(areaUnderCurveColor);
        HashMap peaks = aSpecFile.getPeaks();
        this.iXAxisData.add(new double[peaks.size()]);
        this.iYAxisData.add(new double[peaks.size()]);
        this.iFilename = aSpecFile.getFilename();
        double maxInt = 0.0;
        TreeSet masses = new TreeSet(peaks.keySet());
        Iterator iter = masses.iterator();
        int count = 0;
        while (iter.hasNext()) {
            Double key = (Double)iter.next();
            double mass = key;
            double intensity = (Double)peaks.get(key);
            if (intensity > maxInt) {
                maxInt = intensity;
            }
            ((double[])this.iXAxisData.get((int)this.dataSetCounter))[count] = mass;
            ((double[])this.iYAxisData.get((int)this.dataSetCounter))[count] = intensity;
            ++count;
        }
        if (this.iXAxisStartAtZero) {
            this.rescale(0.0, this.getMaxXAxisValue());
        } else {
            this.rescale(this.getMinXAxisValue(), this.getMaxXAxisValue());
        }
        this.iPrecursorMZ = aSpecFile.getPrecursorMZ();
        int liTemp = aSpecFile.getCharge();
        if (liTemp == 0) {
            this.iPrecursorCharge = "?";
        } else {
            this.iPrecursorCharge = Integer.toString(liTemp);
            this.iPrecursorCharge = this.iPrecursorCharge + (liTemp > 0 ? "+" : "-");
        }
        ++this.dataSetCounter;
    }

    public ArrayList<AASequenceImpl> getPeptideSequences() {
        return this.peptideSequences;
    }
}

