/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.util.mascot.index;

import com.compomics.mascotdatfile.util.exception.MascotDatfileException;
import org.apache.log4j.Logger;

public class SummaryIndex {
    private static Logger logger = Logger.getLogger(SummaryIndex.class);
    private static SummaryIndex singleton = null;
    private static SummaryIndex decoyInstance;
    public static int QMASS;
    public static int QEXP;
    public static int QMATCH;
    public static int QPLUGHOLE;
    public static int QINTENSITY;
    private int iSummaryLineIndex;
    private int iNumberOfIndexes = 0;
    private int mass_index = -1;
    private int exp_index = -1;
    private int match_index = -1;
    private int plughole_index = -1;
    private int intensity_index = -1;

    public void setNumberOfIndexes(int aNumberOfIndexes) {
        this.iNumberOfIndexes = aNumberOfIndexes;
    }

    private SummaryIndex() {
    }

    public static SummaryIndex getInstance() {
        if (singleton == null) {
            singleton = new SummaryIndex();
        }
        return singleton;
    }

    public static SummaryIndex getDecoyInstance() {
        if (decoyInstance == null) {
            decoyInstance = new SummaryIndex();
        }
        return decoyInstance;
    }

    public int getSummaryLine(int aQueryNumber, int aType) {
        int aTypeIndex = this.parseType(aType);
        if (aTypeIndex == -1) {
            throw new MascotDatfileException("Illegal summary type requested: '" + aType + "'.");
        }
        return this.iSummaryLineIndex + ((aQueryNumber - 1) * this.iNumberOfIndexes + this.parseType(aType));
    }

    private int parseType(int aType) {
        if (aType == QMATCH) {
            return this.match_index;
        }
        if (aType == QPLUGHOLE) {
            return this.plughole_index;
        }
        if (aType == QEXP) {
            return this.exp_index;
        }
        if (aType == QMASS) {
            return this.mass_index;
        }
        if (aType == QINTENSITY) {
            return this.intensity_index;
        }
        return -1;
    }

    public void setSummaryLineIndex(int aSummaryLineIndex) {
        this.iSummaryLineIndex = aSummaryLineIndex;
    }

    public int getIndex_type_count() {
        return this.iNumberOfIndexes;
    }

    public int getMass_index() {
        return this.mass_index;
    }

    public void setMass_index(int aMass_index) {
        this.mass_index = aMass_index;
    }

    public int getExp_index() {
        return this.exp_index;
    }

    public void setExp_index(int aExp_index) {
        this.exp_index = aExp_index;
    }

    public int getMatch_index() {
        return this.match_index;
    }

    public void setMatch_index(int aMatch_index) {
        this.match_index = aMatch_index;
    }

    public int getPlughole_index() {
        return this.plughole_index;
    }

    public void setPlughole_index(int aPlughole_index) {
        this.plughole_index = aPlughole_index;
    }

    public int getIntensity_index() {
        return this.intensity_index;
    }

    public void setIntensity_index(int aIntensity_index) {
        this.intensity_index = aIntensity_index;
    }

    public String toString() {
        return "SummaryIndex{iSummaryLineIndex=" + this.iSummaryLineIndex + ", mass_index=" + this.mass_index + ", exp_index=" + this.exp_index + ", match_index=" + this.match_index + ", plughole_index=" + this.plughole_index + ", intensity_index=" + this.intensity_index + '}';
    }

    static {
        QMASS = 0;
        QEXP = 1;
        QMATCH = 2;
        QPLUGHOLE = 3;
        QINTENSITY = 4;
    }
}

