## ----setup, include=FALSE--------------------------------------------------
knitr::opts_chunk$set(echo = TRUE, fig.width = 7, fig.height = 5)

## ----getPackage, eval=FALSE------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#  install.packages("BiocManager")
#  BiocManager::install("sRACIPE")

## ---- eval = FALSE---------------------------------------------------------
#  BiocManager::install(vivekkohar/sRACIPE)

## ----Load, message=FALSE---------------------------------------------------
library(sRACIPE)

## ----eval=TRUE-------------------------------------------------------------
library(sRACIPE)

# Load a demo circuit
data("demoCircuit")
demoCircuit


## --------------------------------------------------------------------------

rSet <- sRACIPE::sracipeSimulate(circuit = demoCircuit, numModels = 20,
                             plots = FALSE, integrateStepSize = 0.1, 
                             simulationTime = 30)


## ----eval=TRUE-------------------------------------------------------------
rSet <- sRACIPE::sracipeNormalize(rSet)
rSet <- sRACIPE::sracipePlotData(rSet, plotToFile = FALSE)


## ----eval=TRUE-------------------------------------------------------------
data("demoCircuit")
rSet <- sRACIPE::sracipeSimulate(circuit = demoCircuit, 
                             numModels = 50, plots = FALSE, 
                             integrateStepSize = 0.1, 
                             simulationTime = 30)
kd <- sRACIPE::sracipeKnockDown(rSet, plotToFile = FALSE,
                                reduceProduction=50)

## ----eval=FALSE------------------------------------------------------------
#   sRACIPE::sracipePlotCircuit(rSet, plotToFile = FALSE)

## ----eval=TRUE-------------------------------------------------------------
rSet <- sRACIPE::sracipeSimulate(circuit = demoCircuit, numModels = 20, 
                             initialNoise = 15, noiseScalingFactor = 0.1,
                             nNoise = 2,
                             plots = TRUE, plotToFile = FALSE, 
                             integrateStepSize = 0.1, 
                             simulationTime = 30)


## ----eval=TRUE-------------------------------------------------------------
rSet <- sRACIPE::sracipeSimulate(circuit = demoCircuit, numModels = 20, 
                             plots = FALSE, integrate = FALSE)
params <- sRACIPE::sracipeParams(rSet)
modifiedParams <- as.matrix(params) 
modifiedParams[,1] <- 0.1*modifiedParams[,1]
sRACIPE::sracipeParams(rSet) <- DataFrame(modifiedParams)
rSet <- sRACIPE::sracipeSimulate(rSet, plots = FALSE, genParams = FALSE)


## --------------------------------------------------------------------------
sessionInfo()

