/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.utils;

import edu.msu.cme.rdp.readseq.readers.core.SFFCore;
import edu.msu.cme.rdp.readseq.writers.SFFWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SFFSplitter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splitInto(File sffFile, Map<String, String> barcodeToSample, File directory) throws IOException {
        SFFCore core = new SFFCore(sffFile);
        SFFCore.CommonHeader ch = core.getCommonHeader();
        HashMap<String, SFFWriter> outputMap = new HashMap<String, SFFWriter>();
        HashMap<String, PrintStream> idOutputMap = new HashMap<String, PrintStream>();
        for (String sample : new HashSet<String>(barcodeToSample.values())) {
            File outFile = new File(directory, sample + ".sff");
            outputMap.put(sample, new SFFWriter(outFile, ch, core.getManifest()));
            idOutputMap.put(sample, new PrintStream(new File(directory, sample + "_seqids.txt")));
        }
        try {
            block4: for (int index = 0; index < ch.getNumReads(); ++index) {
                SFFCore.ReadBlock rb = core.readReadBlock();
                int left = Math.max(rb.getClipAdapterLeft(), rb.getClipQualLeft());
                String trimmedSeq = rb.getSeq().substring(left - 1).toLowerCase();
                for (String barcode : barcodeToSample.keySet()) {
                    if (!trimmedSeq.startsWith(barcode)) continue;
                    String sample = barcodeToSample.get(barcode);
                    ((SFFWriter)outputMap.get(sample)).writeReadBlock(rb);
                    ((PrintStream)idOutputMap.get(sample)).println(rb.getName());
                    continue block4;
                }
            }
        }
        finally {
            for (SFFWriter os : outputMap.values()) {
                os.close();
            }
            for (PrintStream out : idOutputMap.values()) {
                out.close();
            }
        }
    }

    public static void dumpIndex(File f) throws Exception {
        int version;
        SFFCore core = new SFFCore(f);
        RandomAccessFile tmp = new RandomAccessFile(f, "r");
        tmp.seek(core.getCommonHeader().getIndexOffset());
        int mftMagicNumber = 778921588;
        int srtMagicNumber = 779317876;
        int acceptedVersionMagicNumber = 825110576;
        int magicNumber = tmp.readInt();
        if (magicNumber == mftMagicNumber) {
            System.out.println("Found an index header!");
            version = tmp.readInt();
            if (version == acceptedVersionMagicNumber) {
                System.out.println("We've got a version we understand!");
                int xmlSize = tmp.readInt();
                int dataSize = tmp.readInt();
                System.out.println("XML Size=" + xmlSize + ", dataSize=" + dataSize);
                byte[] xml = new byte[xmlSize];
                tmp.read(xml);
                System.out.println(new String(xml));
            }
        } else if (magicNumber == srtMagicNumber) {
            System.out.println("Found an index header!");
            version = tmp.readInt();
            if (version == acceptedVersionMagicNumber) {
                System.out.println("We've got a version we understand!");
                if (tmp.read() != 0) {
                    throw new IOException("GAH NULL BYTE NOT FOUND OMG");
                }
            }
        } else {
            throw new IOException("No supported index found");
        }
        ArrayList<Integer> currIndex = new ArrayList<Integer>();
        while (tmp.getFilePointer() != tmp.length()) {
            int b = tmp.readUnsignedByte();
            if (b == 255) {
                byte[] nameArray = new byte[currIndex.size() - 5];
                long indexLoc = 0L;
                int[] multipliers = new int[]{0, 16581375, 65025, 255, 1};
                for (int i = 0; i < currIndex.size(); ++i) {
                    if (i < nameArray.length) {
                        nameArray[i] = (byte)((Integer)currIndex.get(i) & 0xFF);
                        continue;
                    }
                    int index = i - nameArray.length;
                    indexLoc += (long)((Integer)currIndex.get(i) * multipliers[index]);
                }
                String name = new String(nameArray);
                System.out.println(name + "\t" + indexLoc);
                currIndex.clear();
                continue;
            }
            currIndex.add(b);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.err.println("USAGE: SFFSplitter <sff_file> <barcode_mapping> <output_dir>");
            return;
        }
        File inSff = new File(args[0]);
        File barcodeMappingFile = new File(args[1]);
        File outputDir = new File(args[2]);
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            System.err.println("Failed to make output dir " + outputDir);
            return;
        }
        BufferedReader reader = new BufferedReader(new FileReader(barcodeMappingFile));
        String line = "";
        HashMap<String, String> barcodeMap = new HashMap<String, String>();
        while ((line = reader.readLine()) != null) {
            String[] lexemes = line.trim().split("\\s+");
            if (lexemes.length != 2) continue;
            if (barcodeMap.containsKey(lexemes[0])) {
                System.err.println("Warning: Duplicate mapping for " + lexemes[0] + " " + (String)barcodeMap.get(lexemes[0]) + "," + lexemes[1]);
            }
            barcodeMap.put(lexemes[0].toLowerCase(), lexemes[1]);
        }
        SFFSplitter.splitInto(inSff, barcodeMap, outputDir);
    }
}

