/*
 * Decompiled with CFR 0.152.
 */
package de.proteinms.xtandemparser.xtandem;

import de.proteinms.xtandemparser.interfaces.Ion;
import de.proteinms.xtandemparser.interfaces.Peak;

public class FragmentIon
implements Ion {
    private double iMz = 0.0;
    private double iIntensity = 0.0;
    private int iNumber = 0;
    private int iScore = 0;
    private int iType;
    private double iErrorMargin = 0.0;
    private double iTheoreticalExperimentalMassError;
    private int iCharge;

    public FragmentIon(double aMz, int aType, int aNumber, int aCharge, double aErrorMargin) {
        this.iMz = aMz;
        this.iType = aType;
        this.iNumber = aNumber;
        this.iCharge = aCharge;
        this.iErrorMargin = aErrorMargin;
    }

    public FragmentIon(double aMz, double aIntensity, int aType, int aNumber, int aCharge, double aErrorMargin) {
        this.iMz = aMz;
        this.iIntensity = aIntensity;
        this.iType = aType;
        this.iNumber = aNumber;
        this.iCharge = aCharge;
        this.iType = aType;
        this.iErrorMargin = aErrorMargin;
    }

    @Override
    public boolean isMatch(Peak[] aPeaks, double aMassError) {
        boolean matchFlag = false;
        for (int i = 0; i < aPeaks.length; ++i) {
            if (!(-aMassError <= aPeaks[i].getMZ() - this.iMz) || !(aPeaks[i].getMZ() - this.iMz <= aMassError)) continue;
            this.iTheoreticalExperimentalMassError = aPeaks[i].getMZ() - this.iMz;
            matchFlag = true;
            this.iIntensity = aPeaks[i].getIntensity();
            break;
        }
        return matchFlag;
    }

    @Override
    public double getMZ() {
        return this.iMz;
    }

    @Override
    public double getIntensity() {
        return this.iIntensity;
    }

    @Override
    public int getNumber() {
        return this.iNumber;
    }

    @Override
    public double getScore() {
        return this.iScore;
    }

    @Override
    public int getType() {
        return this.iType;
    }

    public double getErrorMargin() {
        return this.iErrorMargin;
    }

    public double getTheoreticalExperimentalMassError() {
        return this.iTheoreticalExperimentalMassError;
    }

    public double getCharge() {
        return this.iCharge;
    }

    public String getLetter() {
        switch (this.iType) {
            case 0: {
                return "a";
            }
            case 2: {
                return "a-H20";
            }
            case 1: {
                return "a*";
            }
            case 3: {
                return "b";
            }
            case 5: {
                return "b-H20";
            }
            case 4: {
                return "b*";
            }
            case 6: {
                return "c";
            }
            case 7: {
                return "x";
            }
            case 8: {
                return "y";
            }
            case 10: {
                return "y-H20";
            }
            case 9: {
                return "y*";
            }
            case 11: {
                return "z";
            }
            case 12: {
                return "MH";
            }
            case 13: {
                return "MH*";
            }
            case 14: {
                return "MH-H20";
            }
        }
        return null;
    }
}

