/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.CrossProductSymbolNameParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.AbstractAlphabet;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ListWrapper;

class SimpleCrossProductAlphabet
extends AbstractAlphabet
implements Serializable {
    private final Alphabet parent;
    private final List alphas;
    private final HashMap ourSymbols;
    private char tokenSeed = (char)65;
    private transient ListWrapper gopher;

    public SimpleCrossProductAlphabet(List list) throws IllegalAlphabetException {
        this(list, null);
    }

    public SimpleCrossProductAlphabet(List list, Alphabet alphabet) throws IllegalAlphabetException {
        this.parent = alphabet;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Alphabet alphabet2 = (Alphabet)iterator.next();
            if (alphabet2 instanceof FiniteAlphabet) continue;
            throw new IllegalAlphabetException("Can't create a SimpleAlphabetManager over non-fininte alphabet " + alphabet2.getName() + " of type " + alphabet2.getClass());
        }
        this.alphas = Collections.unmodifiableList(new ArrayList(list));
        this.ourSymbols = new HashMap();
        this.populateSymbols(new ArrayList());
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    protected void addSymbolImpl(AtomicSymbol atomicSymbol) throws IllegalSymbolException {
        throw new IllegalSymbolException("Can't add symbols to alphabet: " + atomicSymbol.getName() + " in " + this.getName());
    }

    protected boolean containsImpl(AtomicSymbol atomicSymbol) {
        return this.ourSymbols.values().contains(atomicSymbol);
    }

    public List getAlphabets() {
        return this.alphas;
    }

    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    private ListWrapper getGopher() {
        if (this.gopher == null) {
            this.gopher = new ListWrapper();
        }
        return this.gopher;
    }

    public String getName() {
        StringBuffer stringBuffer = new StringBuffer("(");
        int n = 0;
        while (n < this.alphas.size()) {
            Alphabet alphabet = (Alphabet)this.alphas.get(n);
            stringBuffer.append(alphabet.getName());
            if (n < this.alphas.size() - 1) {
                stringBuffer.append(" x ");
            }
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public SymbolParser getParser(String string) throws NoSuchElementException {
        if (string == "name") {
            try {
                return new CrossProductSymbolNameParser(this);
            }
            catch (BioException bioException) {
                throw new NoSuchElementException("Couldn't build parser for " + string + ": " + bioException.getMessage());
            }
        }
        throw new NoSuchElementException("No parser for " + string + " is defined for " + this.getName());
    }

    public AtomicSymbol getSymbolImpl(List list) throws IllegalSymbolException {
        AtomicSymbol atomicSymbol;
        ListWrapper listWrapper;
        ListWrapper listWrapper2 = listWrapper = this.getGopher();
        synchronized (listWrapper2) {
            listWrapper.setList(list);
            atomicSymbol = (AtomicSymbol)this.ourSymbols.get(listWrapper);
        }
        if (atomicSymbol == null) {
            throw new IllegalSymbolException("Can't find symbol for " + list);
        }
        return atomicSymbol;
    }

    public Iterator iterator() {
        return this.ourSymbols.values().iterator();
    }

    private void populateSymbols(List list) {
        if (list.size() == this.alphas.size()) {
            this.putSymbol(list);
        } else {
            int n = list.size();
            FiniteAlphabet finiteAlphabet = (FiniteAlphabet)this.alphas.get(n);
            Iterator iterator = finiteAlphabet.iterator();
            if (iterator.hasNext()) {
                list.add(iterator.next());
                this.populateSymbols(list);
                while (iterator.hasNext()) {
                    list.set(n, iterator.next());
                    this.populateSymbols(list);
                }
                list.remove(n);
            }
        }
    }

    private AtomicSymbol putSymbol(List list) {
        AtomicSymbol atomicSymbol;
        if (this.parent != null) {
            try {
                atomicSymbol = (AtomicSymbol)this.parent.getSymbol(list);
            }
            catch (IllegalSymbolException illegalSymbolException) {
                throw new BioError(illegalSymbolException, "Balls up - couldn't fetch symbol from parent");
            }
        }
        try {
            char c = this.tokenSeed;
            this.tokenSeed = (char)(c + '\u0001');
            atomicSymbol = (AtomicSymbol)AlphabetManager.createSymbol(c, Annotation.EMPTY_ANNOTATION, list, (Alphabet)this);
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioError(illegalSymbolException, "Assertion Failure: Should have a legal symbol.");
        }
        this.ourSymbols.put(new ListWrapper(atomicSymbol.getSymbols()), atomicSymbol);
        return atomicSymbol;
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public void removeSymbol(Symbol symbol) throws IllegalSymbolException {
        throw new IllegalSymbolException("Can't remove symbols from alphabet: " + symbol.getName() + " in " + this.getName());
    }

    public int size() {
        return this.ourSymbols.size();
    }

    public SymbolList symbols() {
        try {
            return new SimpleSymbolList(this, new ArrayList(this.ourSymbols.values()));
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioError(illegalSymbolException);
        }
    }
}

