/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.converter.impl253;

import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.converter.impl253.AttributeConverter;
import psidev.psi.mi.xml.converter.impl253.BibrefConverter;
import psidev.psi.mi.xml.converter.impl253.NamesConverter;
import psidev.psi.mi.xml.converter.impl253.PsiXmlCalendar;
import psidev.psi.mi.xml.converter.impl253.XrefConverter;
import psidev.psi.mi.xml.model.Attribute;
import psidev.psi.mi.xml.model.Source;
import psidev.psi.mi.xml253.jaxb.AttributeListType;
import psidev.psi.mi.xml253.jaxb.EntryType;

public class SourceConverter {
    private BibrefConverter bibrefConverter = new BibrefConverter();
    private NamesConverter namesConverter = new NamesConverter();
    private XrefConverter xrefConverter = new XrefConverter();
    private AttributeConverter attributeConverter = new AttributeConverter();

    public Source fromJaxb(EntryType.Source jSource) {
        if (jSource == null) {
            throw new IllegalArgumentException("You must give a non null JAXB Source.");
        }
        Source mSource = new Source();
        mSource.setRelease(jSource.getRelease());
        XMLGregorianCalendar jReleaseDate = jSource.getReleaseDate();
        if (jReleaseDate != null) {
            GregorianCalendar gregorianCalendar = jReleaseDate.toGregorianCalendar();
            Date mReleaseDate = gregorianCalendar.getTime();
            mSource.setReleaseDate(mReleaseDate);
        }
        if (jSource.getBibref() != null) {
            mSource.setBibref(this.bibrefConverter.fromJaxb(jSource.getBibref()));
        }
        if (jSource.getNames() != null) {
            mSource.setNames(this.namesConverter.fromJaxb(jSource.getNames()));
        }
        if (jSource.getXref() != null) {
            mSource.setXref(this.xrefConverter.fromJaxb(jSource.getXref()));
        }
        if (jSource.getAttributeList() != null) {
            for (AttributeListType.Attribute jAttribute : jSource.getAttributeList().getAttributes()) {
                mSource.getAttributes().add(this.attributeConverter.fromJaxb(jAttribute));
            }
        }
        return mSource;
    }

    public EntryType.Source toJaxb(Source mSource) throws ConverterException {
        if (mSource == null) {
            throw new IllegalArgumentException("You must give a non null model Source.");
        }
        EntryType.Source jSource = new EntryType.Source();
        jSource.setRelease(mSource.getRelease());
        try {
            Date mReleaseDate = mSource.getReleaseDate();
            if (mReleaseDate != null) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(mReleaseDate);
                PsiXmlCalendar xmlCal = new PsiXmlCalendar(DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar));
                jSource.setReleaseDate(xmlCal);
            }
        }
        catch (DatatypeConfigurationException e2) {
            throw new ConverterException("Error while converting Date to XMLGregorianCalendar. See nested Exception", e2);
        }
        if (mSource.hasBibref()) {
            jSource.setBibref(this.bibrefConverter.toJaxb(mSource.getBibref()));
        }
        if (mSource.hasNames()) {
            jSource.setNames(this.namesConverter.toJaxb(mSource.getNames()));
        }
        if (mSource.hasXref()) {
            jSource.setXref(this.xrefConverter.toJaxb(mSource.getXref()));
        }
        if (mSource.hasAttributes()) {
            if (jSource.getAttributeList() == null) {
                jSource.setAttributeList(new AttributeListType());
            }
            for (Attribute mAttribute : mSource.getAttributes()) {
                jSource.getAttributeList().getAttributes().add(this.attributeConverter.toJaxb(mAttribute));
            }
        }
        return jSource;
    }
}

