## ----setup,echo=FALSE------------------------------------------------------
suppressPackageStartupMessages({
library(knitr)
library(ontoProc)
go = getGeneOnto()
cl = getCellOnto()
pr = getPROnto()
library(ontologyPlot)
library(BiocStyle)
})

## ----lksco-----------------------------------------------------------------
kable(packDesc2019)

## ----lklk------------------------------------------------------------------
kable(stab <- seur3kTab())

## ----lklklk----------------------------------------------------------------
library(ontoProc)
cl = getCellOnto()
onto_plot2(cl, stab$tag)

## ----lkfa------------------------------------------------------------------
kable(CLfeats(cl, "CL:0002531"))

## ----lksy------------------------------------------------------------------
kable(sdf <- as.data.frame(sym2CellOnto("ITGAM", cl, pr)))
table(sdf$cond)
kable(as.data.frame(sym2CellOnto("FOXP3", cl, pr)))

## ----lksig-----------------------------------------------------------------
sigels = c("CL:X01"="GRIK3", "CL:X02"="NTNG1", "CL:X03"="BAGE2",
             "CL:X04"="MC4R", "CL:X05"="PAX6", "CL:X06"="TSPAN12", 
             "CL:X07"="hSHISA8", "CL:X08"="SNCG", "CL:X09"="ARHGEF28", 
             "CL:X10"="EGF")

## ----lkdfff----------------------------------------------------------------
cs = cyclicSigset(sigels)
dim(cs)
cs[c(1:5,9:13),]
table(cs$cond)

## ----lklk1-----------------------------------------------------------------
 makeIntnProlog = function(id, ...) {
 # make type-specific prologs as key-value pairs
     c(  
       sprintf("id: %s", id),
       sprintf("name: %s-expressing cortical layer 1 interneuron, human", ...),
       sprintf("def: '%s-expressing cortical layer 1 interneuron, human described via RNA-seq observations' [PMID 29322913]", ...),
       "is_a: CL:0000099 ! interneuron",
       "intersection_of: CL:0000099 ! interneuron")
 }

## ----doterm----------------------------------------------------------------
pmap = c("hasExp"="has_expression_of", lacksExp="lacks_expression_of")
head(unlist(tms <- ldfToTerms(cs, pmap, sigels, makeIntnProlog)), 20)

