## ----style, echo=FALSE, results="asis", message=FALSE----------------------
BiocStyle::markdown()
knitr::opts_chunk$set(tidy = FALSE,
    warning = FALSE,
    message = FALSE)

## ----echo=FALSE, results='hide', message=FALSE-----------------------------
library(miRSM)

## ---- eval=TRUE, include=TRUE----------------------------------------------
data(BRCASampleData)

## ---- eval=TRUE, include=TRUE----------------------------------------------
modulegenes_WGCNA <- module_WGCNA(ceRExp[, seq_len(80)], 
                                  mRExp[, seq_len(80)])
modulegenes_WGCNA

## ---- eval=FALSE, include=TRUE---------------------------------------------
#  modulegenes_GFA <- module_GFA(ceRExp[seq_len(20), seq_len(15)],
#                                mRExp[seq_len(20), seq_len(15)],
#                                iter.max = 2600)
#  modulegenes_GFA

## ---- eval=TRUE, include=TRUE----------------------------------------------
modulegenes_igraph <- module_igraph(ceRExp[, seq_len(10)],
                                    mRExp[, seq_len(10)])
modulegenes_igraph

## ---- eval=TRUE, include=TRUE----------------------------------------------
modulegenes_ProNet <- module_ProNet(ceRExp[, seq_len(10)],
                                    mRExp[, seq_len(10)])
modulegenes_ProNet

## ---- eval=TRUE, include=TRUE----------------------------------------------
# Reimport NMF package to avoid conflicts with DelayedArray package
library(NMF)
modulegenes_NMF <- module_NMF(ceRExp[, seq_len(10)],
                              mRExp[, seq_len(10)])
modulegenes_NMF

## ---- eval=TRUE, include=TRUE----------------------------------------------
modulegenes_clust <- module_clust(ceRExp[, seq_len(30)],
                                  mRExp[, seq_len(30)])
modulegenes_clust

## ---- eval=TRUE, include=TRUE----------------------------------------------
modulegenes_biclust <- module_biclust(ceRExp[, seq_len(30)],
                                      mRExp[, seq_len(30)])
modulegenes_biclust

## ---- eval=TRUE, include=TRUE----------------------------------------------
modulegenes_igraph <- module_igraph(ceRExp[, seq_len(10)], 
                                  mRExp[, seq_len(10)])
# Identify miRNA sponge modules using cannonical correlation (CC)
miRSM_igraph_CC <- miRSM(miRExp, ceRExp, mRExp, miRTarget, 
                        modulegenes_igraph, nperms = 5, 
                        num_shared_miRNAs = 3, pvalue.cutoff = 0.05, 
                        method = "CC", CC.cutoff = 0.8)
miRSM_igraph_CC

## ---- eval=FALSE, include=TRUE---------------------------------------------
#  modulegenes_WGCNA <- module_WGCNA(ceRExp[, seq_len(150)],
#                                    mRExp[, seq_len(150)])
#  # Identify miRNA sponge modules using cannonical correlation (CC)
#  miRSM_WGCNA_CC <- miRSM(miRExp, ceRExp, mRExp, miRTarget,
#                          modulegenes_WGCNA, nperms = 5,
#                          method = "CC")
#  miRSM_WGCNA_CC_genes <- miRSM_WGCNA_CC[[2]]
#  miRSM_WGCNA_CC_FEA <- module_FA(miRSM_WGCNA_CC_genes,
#                                  Analysis.type ="FEA")
#  miRSM_WGCNA_CC_DEA <- module_FA(miRSM_WGCNA_CC_genes,
#                                  Analysis.type = "DEA")

## ---- eval=TRUE, include=TRUE----------------------------------------------
modulegenes_WGCNA <- module_WGCNA(ceRExp[, seq_len(150)], 
                                  mRExp[, seq_len(150)])
# Identify miRNA sponge modules using cannonical correlation (CC)
miRSM_WGCNA_CC <- miRSM(miRExp, ceRExp, mRExp, miRTarget, 
                        modulegenes_WGCNA, nperms = 5, 
                        method = "CC")
miRSM_WGCNA_CC_genes <- miRSM_WGCNA_CC[[2]]
miRSM.CEA.pvalue <- module_CEA(ceRExp, mRExp, BRCA_genes, miRSM_WGCNA_CC_genes)
miRSM.CEA.pvalue

## ---- eval=FALSE, include=TRUE---------------------------------------------
#  # Using the built-in groundtruth from the miRspongeR package
#  library(miRspongeR)
#  Groundtruthcsv <- system.file("extdata", "Groundtruth.csv", package="miRspongeR")
#  Groundtruth <- read.csv(Groundtruthcsv, header=TRUE, sep=",")
#  # Using the identified miRNA sponge modules based on WGCNA and cannonical correlation (CC) method
#  miRSM.Validate <- module_Validate(miRSM_WGCNA_CC_genes, Groundtruth)

## ---- eval=TRUE, include=TRUE----------------------------------------------
# Using the identified miRNA sponge modules based on WGCNA and cannonical correlation (CC) method
miRSM_WGCNA_Coexpress <-  module_Coexpress(ceRExp, mRExp, miRSM_WGCNA_CC_genes, resample = 10, method = "mean")
miRSM_WGCNA_Coexpress

## ---- eval=TRUE, include=TRUE----------------------------------------------
# Using the identified miRNA sponge modules based on WGCNA and cannonical correlation (CC) method
miRSM_WGCNA_share_miRs <-  share_miRs(miRExp, ceRExp, mRExp, miRTarget, miRSM_WGCNA_CC_genes)
miRSM_WGCNA_miRdistribute <- module_miRdistribute(miRSM_WGCNA_share_miRs)
head(miRSM_WGCNA_miRdistribute)

## ---- eval=FALSE, include=TRUE---------------------------------------------
#  # Using the identified miRNA sponge modules based on WGCNA and cannonical correlation (CC) method
#  miRSM_WGCNA_miRtarget <- module_miRtarget(miRSM_WGCNA_share_miRs, miRSM_WGCNA_CC_genes)

## ---- eval=FALSE, include=TRUE---------------------------------------------
#  # Using the identified miRNA sponge modules based on WGCNA and cannonical correlation (CC) method
#  miRSM_WGCNA_miRsponge <- module_miRsponge(ceRExp, mRExp, miRSM_WGCNA_CC_genes)

## --------------------------------------------------------------------------
sessionInfo()

