## ----setup, include = FALSE------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>",
    error = FALSE,
    warning = FALSE,
    message = FALSE
)
stopifnot(requireNamespace("htmltools"))
htmltools::tagList(rmarkdown::html_dependency_font_awesome())

## ---- echo=FALSE, out.width='50%', fig.align='center'----------------------
knitr::include_graphics(path = system.file(package="iSEE", "www/iSEE.png", mustWork=TRUE))

## ----library---------------------------------------------------------------
library(iSEE)

## ----demostart, eval=FALSE-------------------------------------------------
#  iSEE(se)

## ----quickstart, eval=FALSE------------------------------------------------
#  example(iSEE, ask=FALSE)

## ----allen-dataset---------------------------------------------------------
library(scRNAseq)
data(allen)
allen

## ----colData_sce-----------------------------------------------------------
colnames(colData(allen))

## --------------------------------------------------------------------------
library(scater)
sce <- as(allen, "SingleCellExperiment")
counts(sce) <- assay(sce, "tophat_counts")
sce <- normalize(sce)

## ----allen-dataset-2-------------------------------------------------------
sce <- runPCA(sce)
sce <- runTSNE(sce)
reducedDimNames(sce)

## --------------------------------------------------------------------------
rowData(sce)$mean_log <- rowMeans(logcounts(sce))
rowData(sce)$var_log <- apply(logcounts(sce), 1, var)

## ---- echo=FALSE, results="hide"-------------------------------------------
# Saving and reloading so we don't have to run it again later.
# This requires that NO OTHER VIGNETTE is alphabetically ordered before this one.
saveRDS(file="sce.rds", sce)

## ----allen-dataset-4-------------------------------------------------------
app <- iSEE(sce)

## ----runApp, eval=FALSE----------------------------------------------------
#  shiny::runApp(app)

## ----citation--------------------------------------------------------------
citation("iSEE")

## ----sessioninfo-----------------------------------------------------------
sessionInfo()
# devtools::session_info()

