## ----echo=FALSE, message=FALSE---------------------------------------------
knitr::opts_chunk$set(message=FALSE)
devtools::load_all(".")

## ----get_package, eval=FALSE-----------------------------------------------
#  
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#  install.packages("BiocManager")
#  BiocManager::install("hypeR")
#  

## ---- eval=FALSE-----------------------------------------------------------
#  
#  BiocManager::install("montilab/hypeR")
#  

## ----load, message=FALSE---------------------------------------------------

library(hypeR)


## --------------------------------------------------------------------------

msigdb_info <- hypeR::download_msigdb(species="Homo sapiens") 


## --------------------------------------------------------------------------

symbols <- c("IDH3B","DLST","PCK2","CS","PDHB","PCK1","PDHA1","LOC642502",
             "PDHA2","LOC283398","FH","SDHD","OGDH","SDHB","IDH3A","SDHC",
             "IDH2","IDH1","OGDHL","PC","SDHA","SUCLG1","SUCLA2","SUCLG2")


## --------------------------------------------------------------------------

db_info()


## --------------------------------------------------------------------------

BIOCARTA <- db_get(msigdb_info, "C2.CP.BIOCARTA")
KEGG     <- db_get(msigdb_info, "C2.CP.KEGG")
REACTOME <- db_get(msigdb_info, "C2.CP.REACTOME")

gsets <- c(BIOCARTA, KEGG, REACTOME)


## --------------------------------------------------------------------------

hyp <- hypeR(symbols, gsets, bg=7842, fdr=0.05)


## --------------------------------------------------------------------------

hyp_plot(hyp)


## --------------------------------------------------------------------------

hyp_show(hyp)


## ---- eval=FALSE-----------------------------------------------------------
#  
#  hyp_to_excel(hyp, file.path="pathways.xlsx")
#  

## ---- eval=FALSE-----------------------------------------------------------
#  
#  hyp_to_table(hyp, file.path="pathways.txt")
#  

## --------------------------------------------------------------------------

url = "http://amp.pharm.mssm.edu/Enrichr/geneSetLibrary?mode=text&libraryName=Cancer_Cell_Line_Encyclopedia"
r <- httr::GET(url)
text <- httr::content(r, "text", encoding="ISO-8859-1")
text.split <- strsplit(text, "\n")[[1]]
gsets <- sapply(text.split, function(x) {
    genes <- strsplit(x, "\t")[[1]]
    return(genes[3:length(genes)])
})
names(gsets) <- unlist(lapply(text.split, function(x) strsplit(x, "\t")[[1]][1]))

hyp <- hypeR(symbols, gsets, bg=7842, fdr=0.05)


## --------------------------------------------------------------------------

url = "https://www.genenames.org/cgi-bin/download/custom?col=gd_app_sym&chr=X&chr=Y&format=text"
r <- httr::GET(url)
text <- httr::content(r, "text", encoding="ISO-8859-1")
text.split <- strsplit(text, "\n")[[1]]

bg <- text.split[2:length(text.split)]
head(bg)

hyp <- hypeR(symbols, gsets, bg=bg)


## --------------------------------------------------------------------------

sessionInfo()


