## ----setu,echo=FALSE,results="hide"--------------------------------------
suppressMessages({
suppressPackageStartupMessages({
library(hmdbQuery)
library(gwascat)
})
})

## ----lk1-----------------------------------------------------------------
library(hmdbQuery)
lk1 = HmdbEntry(prefix = "http://www.hmdb.ca/metabolites/", 
       id = "HMDB0000001")

## ----lk2-----------------------------------------------------------------
lk1

## ----lkta----------------------------------------------------------------
data(hmdb_disease)
hmdb_disease

## ----lkdis3--------------------------------------------------------------
diseases(lk1)
pmids = unlist(diseases(lk1)[1,]$pmids)
library(annotate)
pm = pubmed(pmids[1])
ab = buildPubMedAbst(xmlRoot(pm)[[1]])
ab

## ----lkdee---------------------------------------------------------------
biospecimens(lk1)
tissues(lk1)
st = store(lk1)
head(names(st))
length(names(st))
sapply(store(lk1)$protein_associations, "[[", "name")
sapply(store(lk1)$protein_associations, "[[", "gene_name")

