### R code from vignette source 'flowDensityVignette.Rnw'

###################################################
### code chunk number 1: flowDensityVignette.Rnw:85-93
###################################################
library(flowCore)
library(flowDensity)
data_dir <- system.file("extdata", package = "flowDensity")
load(list.files(pattern = 'sampleFCS_1', data_dir, full = TRUE))
f
sngl <- flowDensity(f,channels = c("FSC-A","FSC-H"),position = c(F,F),
                    percentile =c(.99999,.99999),use.percentile = c(T,T),
                    ellip.gate = T,scale = .99 )


###################################################
### code chunk number 2: plotsngl
###################################################
plotDens(f,c(1,2))
lines(sngl@filter,type="l")


###################################################
### code chunk number 3: fig1
###################################################
plotDens(f,c(1,2))
lines(sngl@filter,type="l")


###################################################
### code chunk number 4: flowDensityVignette.Rnw:110-112
###################################################
bcell <- flowDensity(sngl, channels=c(9, 3),
                     position=c(FALSE, NA))


###################################################
### code chunk number 5: plotBcell
###################################################
plot(getflowFrame(sngl), bcell)


###################################################
### code chunk number 6: fig2
###################################################
plot(getflowFrame(sngl), bcell)


###################################################
### code chunk number 7: flowDensityVignette.Rnw:152-158
###################################################
CD19pCD20n <- flowDensity(obj=bcell, channels=c(8, 6),
                        position=c(T,F))
plasmablasts <- flowDensity(obj=CD19pCD20n, channels=c(5, 12),
                            position=c(T, T))
plotDens(getflowFrame(CD19pCD20n), plasmablasts@channels, pch=19)
points(plasmablasts@filter, type='l', col=2, lwd=2)


###################################################
### code chunk number 8: plotPlasmablasts
###################################################
plotDens(getflowFrame(CD19pCD20n), plasmablasts@channels, pch=19)
points(plasmablasts@filter, type='l', col=2, lwd=2)


###################################################
### code chunk number 9: flowDensityVignette.Rnw:168-169
###################################################
plotDens(getflowFrame(CD19pCD20n), plasmablasts@channels, pch=19)
points(plasmablasts@filter, type='l', col=2, lwd=2)


###################################################
### code chunk number 10: flowDensityVignette.Rnw:197-200
###################################################
f <- nmRemove(f, c("FSC-A", "SSC-A"))
#plotDens(f, c("FSC-A", "SSC-A"))
#plot(f, lymph)


###################################################
### code chunk number 11: flowDensityVignette.Rnw:205-219
###################################################
load(list.files(pattern = 'sampleFCS_2', data_dir, full = TRUE))
f2
channels <- c("V500-A", "SSC-A")
# First call to flowDensity
tmp.cp1 <- flowDensity(obj=f2, channels=channels,
                      position=c(TRUE, FALSE), percentile=c(0.25, NA))
# Second call to flowDensity
tmp.cp2 <- flowDensity(obj=tmp.cp1, channels=channels,
                       position=c(TRUE, FALSE), gates=c(FALSE, NA), 
                       percentile=c(NA, 0.85))
# Final call to flowDensity
lymph <- flowDensity(obj=f2, channels=channels,
                     position=c(TRUE, FALSE), gates=c(tmp.cp1@gates[1], 
                     tmp.cp2@gates[2]), ellip.gate=TRUE, scale=.99)


###################################################
### code chunk number 12: plotTmp1
###################################################
plot(f2, tmp.cp1)


###################################################
### code chunk number 13: plotLymph2
###################################################
plot(f2, tmp.cp2)


###################################################
### code chunk number 14: plotFinalLymph2
###################################################
plotDens(f2, channels=channels)
points(lymph@filter, type="l", col=2, lwd=2)


###################################################
### code chunk number 15: flowDensityVignette.Rnw:237-238
###################################################
plot(f2, tmp.cp1)


###################################################
### code chunk number 16: flowDensityVignette.Rnw:240-241
###################################################
plot(f2, tmp.cp2)


###################################################
### code chunk number 17: flowDensityVignette.Rnw:250-251
###################################################
plotDens(f2, channels=channels)
points(lymph@filter, type="l", col=2, lwd=2)


###################################################
### code chunk number 18: flowDensityVignette.Rnw:279-289
###################################################
load(list.files(pattern = 'sampleFCS_3.Rdata', data_dir, full = TRUE))
f3
load(list.files(pattern = 'sampleFCS_3_FMO', data_dir, full = TRUE))
f3.fmo
f3.gated <- flowDensity(obj=f3, channels=c('BV421-A', 'FSC-A'),
                        position = c(TRUE, NA),use.control = c(TRUE, F)
                        , control = c(f3.fmo, NA))
f3.fmo.gated <- flowDensity(obj=f3.fmo, channels=c('BV421-A', 'FSC-A'),
                            position=c(TRUE, NA),
                            gates=c(f3.gated@gates[1], NA))


###################################################
### code chunk number 19: fmoDefault1
###################################################
plot(f3.fmo, f3.fmo.gated)


###################################################
### code chunk number 20: fmoDefault2
###################################################
plot(f3, f3.gated)


###################################################
### code chunk number 21: flowDensityVignette.Rnw:304-305
###################################################
plot(f3.fmo, f3.fmo.gated)


###################################################
### code chunk number 22: flowDensityVignette.Rnw:307-308
###################################################
plot(f3, f3.gated)


###################################################
### code chunk number 23: flowDensityVignette.Rnw:319-326
###################################################
f3.gated.98p <- flowDensity(obj=f3, channels=c('BV421-A', 'FSC-A'),
                            position = c(TRUE, NA),use.percentile = c(TRUE, NA),
                            percentile = 0.98, use.control = c(TRUE, FALSE),
                            control = c(f3.fmo, NA))
f3.fmo.gated.98p <- flowDensity(obj=f3.fmo, channels=c('BV421-A', 'FSC-A'),
                                position = c(TRUE, NA),
                                gates=c(f3.gated.98p@gates[1], NA))


###################################################
### code chunk number 24: fmoPercentile1
###################################################
plot(f3.fmo, f3.fmo.gated.98p)


###################################################
### code chunk number 25: fmoPercentile2
###################################################
plot(f3, f3.gated.98p)


###################################################
### code chunk number 26: flowDensityVignette.Rnw:339-340
###################################################
plot(f3.fmo, f3.fmo.gated.98p)


###################################################
### code chunk number 27: flowDensityVignette.Rnw:342-343
###################################################
plot(f3, f3.gated.98p)


###################################################
### code chunk number 28: flowDensityVignette.Rnw:360-366
###################################################
load(list.files(pattern = 'sampleFCS_2', data_dir, full = TRUE))
thresholds <- deGate(obj = f2,channel = 9)
#Percentile default is .95, which can be changed
thresholds.prcnt <- deGate(f2,channel = 9,use.percentile=T,percentile=.3) 
thresholds.lo <- deGate(f2,channel = 9,use.upper=T,upper=F,alpha = .9)
thresholds.hi <- deGate(f2,channel = 9,use.upper=T,upper=T,alpha = .9)


###################################################
### code chunk number 29: deGate
###################################################
plotDens(f2,c(9,12))
abline(v=c(thresholds,thresholds.prcnt,thresholds.lo,thresholds.hi),col=c(1,2,3,4))


###################################################
### code chunk number 30: flowDensityVignette.Rnw:375-376
###################################################
plotDens(f2,c(9,12))
abline(v=c(thresholds,thresholds.prcnt,thresholds.lo,thresholds.hi),col=c(1,2,3,4))


