## ---- eval= FALSE----------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly=TRUE)){
#      install.packages("BiocManager")}
#  BiocManager::install("celda")

## ---- eval=TRUE, message=FALSE---------------------------------------------
library(celda)

## --------------------------------------------------------------------------
simCounts <- simulateContaminatedMatrix(G = 300, C = 100, K = 3)

## --------------------------------------------------------------------------
contamination <- simCounts$observedCounts - simCounts$nativeCounts

## --------------------------------------------------------------------------
table(simCounts$z)

## --------------------------------------------------------------------------
colSums(simCounts$phi)
colSums(simCounts$eta)

## ---- warning = FALSE, message = FALSE-------------------------------------
decontxModel <- decontX(counts = simCounts$observedCounts, z = simCounts$z)

## ---- eval = TRUE, fig.width = 5, fig.height = 5---------------------------
plot(decontxModel$resList$logLikelihood)

## ---- eval = TRUE, fig.width = 5, fig.height = 5---------------------------
plot(decontxModel$resList$estConp,
    colSums(contamination) / simCounts$NByC, col = simCounts$z)
abline(0, 1)

## --------------------------------------------------------------------------
sessionInfo()

